/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import com.google.common.collect.AbstractIterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public final class BlockPosUtil {
    private BlockPosUtil() {
    }

    public static BlockPos getNonOffsetPos(@Nonnull Entity entity) {
        return entity.func_233580_cy_().func_185334_h();
    }

    public static BlockPos.Mutable setPos(@Nonnull BlockPos.Mutable pos, @Nonnull Vector3d vec) {
        return pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean canFormCuboid(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return p1.func_177958_n() != p2.func_177958_n() && p1.func_177952_p() != p2.func_177952_p() && p1.func_177956_o() != p2.func_177956_o();
    }

    public static BlockPos createMinPoint(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return new BlockPos(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static BlockPos createMaxPoint(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return new BlockPos(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static boolean contains(@Nonnull BlockPos test, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        return test.func_177958_n() >= min.func_177958_n() && test.func_177958_n() <= max.func_177958_n() && test.func_177956_o() >= min.func_177956_o() && test.func_177956_o() <= max.func_177956_o() && test.func_177952_p() >= min.func_177952_p() && test.func_177952_p() <= max.func_177952_p();
    }

    public static boolean notContains(@Nonnull BlockPos test, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        return test.func_177958_n() < min.func_177958_n() || test.func_177958_n() > max.func_177958_n() || test.func_177956_o() < min.func_177956_o() || test.func_177956_o() > max.func_177956_o() || test.func_177952_p() < min.func_177952_p() || test.func_177952_p() > max.func_177952_p();
    }

    public static Iterable<BlockPos.Mutable> getAllInBoxMutable(@Nonnull BlockPos from, @Nonnull BlockPos to) {
        final BlockPos minPos = BlockPosUtil.createMinPoint(from, to);
        final BlockPos maxPos = BlockPosUtil.createMaxPoint(from, to);
        return () -> new AbstractIterator<BlockPos.Mutable>(){
            private final int minX;
            private final int minY;
            private final int minZ;
            private final int maxX;
            private final int maxY;
            private final int maxZ;
            private BlockPos.Mutable currentPos;
            private int currentX;
            private int currentY;
            private int currentZ;
            {
                this.minX = minPos.func_177958_n();
                this.minY = minPos.func_177956_o();
                this.minZ = minPos.func_177952_p();
                this.maxX = maxPos.func_177958_n();
                this.maxY = maxPos.func_177956_o();
                this.maxZ = maxPos.func_177952_p();
                this.currentX = this.minX;
                this.currentY = this.minY;
                this.currentZ = this.minZ;
            }

            private boolean isEndFinished() {
                return this.currentX == this.maxX && this.currentY == this.maxY && this.currentZ == this.maxZ;
            }

            protected BlockPos.Mutable computeNext() {
                if (this.currentPos == null) {
                    this.currentPos = new BlockPos.Mutable(this.minX, this.minY, this.minZ);
                    return this.currentPos;
                }
                if (this.isEndFinished()) {
                    return (BlockPos.Mutable)this.endOfData();
                }
                if (this.currentX < this.maxX) {
                    ++this.currentX;
                } else if (this.currentZ < this.maxZ) {
                    this.currentX = this.minX;
                    ++this.currentZ;
                } else if (this.currentY < this.maxY) {
                    this.currentX = this.minX;
                    this.currentZ = this.minZ;
                    ++this.currentY;
                }
                this.currentPos.func_181079_c(this.currentX, this.currentY, this.currentZ);
                return this.currentPos;
            }
        };
    }
}

